#include "texManager.h"
#include "renderer.h"
// ======== ======== ======== ======== ======== ======== ======== ========
// 
// -------- -------- -------- -------- -------- -------- -------- --------
void CTexManager::Init()
{
	m_umapTexInterface.clear();
}

// ======== ======== ======== ======== ======== ======== ======== ========
// I
// -------- -------- -------- -------- -------- -------- -------- --------
void CTexManager::Uninit()
{
	ReleaseAll();
}

// ======== ======== ======== ======== ======== ======== ======== ========
// eNX`ݒ
// -------- -------- -------- -------- -------- -------- -------- --------
bool CTexManager::SetTex(const std::string &strFilePass)
{
	// null`FbN
	if(strFilePass.empty()){return false;}

	// vf̗Lm߂
	if(m_umapTexInterface.count(strFilePass) == 1)
	{// ܂
		return true;
	}

	// foCX̎擾
	LPDIRECT3DDEVICE9 pDevice = CRenderer::GetDevice();

	// eNX`C^[tF[XɃf[^
	LPDIRECT3DTEXTURE9 texInterface = nullptr;
	if(D3DXCreateTextureFromFile(pDevice, &strFilePass[0], &texInterface) < 0)
	{
		assert(!"eNX`̓ǂݍ݂Ɏs܂");
		return false;
	}

	// vf̒ǉ
	m_umapTexInterface.insert(std::make_pair(strFilePass, texInterface));

	// ǉ܂
	return true;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// eNX`擾
// -------- -------- -------- -------- -------- -------- -------- --------
LPDIRECT3DTEXTURE9 CTexManager::GetTexInterface(const std::string &strFilePass)
{
	// null`FbN
	if(strFilePass.empty())
	{
		return nullptr;
	}

	// vf̗Lm߂
	if(m_umapTexInterface.count(strFilePass) == 1)
	{// ܂
		return m_umapTexInterface.at(strFilePass);
	}

	// ̗vf͖ł
	return nullptr;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// eNX`̗LmF
// -------- -------- -------- -------- -------- -------- -------- --------
bool CTexManager::CheckTex(const std::string &strFilePass)
{
	// null`FbN
	if (strFilePass.empty())
	{
		assert(!"eNX`̃t@C̎w肪Ă܂");
	}

	// vf̗Lm߂
	if (m_umapTexInterface.count(strFilePass) == 1)
	{// ܂
		return true;
	}

	// ̗vf͖ł
	return false;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// eNX`
// -------- -------- -------- -------- -------- -------- -------- --------
bool CTexManager::Release(const std::string &strFilePass)
{
	// 󂩊m߂
	if(strFilePass.empty()){return false;}
	
	// vf̗Lm߂
	if(m_umapTexInterface.count(strFilePass) == 1)
	{// ܂
		m_umapTexInterface.at(strFilePass)->Release();	// obt@̉
		m_umapTexInterface.erase(strFilePass);			// vf̍폜

		return true;
	}
	return false;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// eNX`S
// -------- -------- -------- -------- -------- -------- -------- --------
void CTexManager::ReleaseAll(void)
{
	// Rei𖖔܂Ń[v
	for(auto it = m_umapTexInterface.begin(); it != m_umapTexInterface.end();)
	{
		if(m_umapTexInterface[it->first] != nullptr)
		{
			m_umapTexInterface[it->first]->Release();	// obt@̉
		}
		m_umapTexInterface.erase(it++);				// t@CpX폜
	}
}